package gov.va.med.domain.service.messaging.encode.hl7.structure;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.PID;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.log.HapiLogFactory;

/**
 * QBP_Q13_RXP
 *
 * @author Slava Uchitel
 * @version $Id: QBP_Q13.java,v 1.2 2005/04/01 08:02:44 jon.crater Exp $
 * @since MHV 2.0 <br>Mar 1, 2005
 */
public class QBP_Q13 extends ca.uhn.hl7v2.model.v24.message.QBP_Q13 {
	/**
	 * Creates a new QBP_Q13 Group.
	 */
	public QBP_Q13() {
		super();
		try {
			this.add(PID.class, true, false);
		}
		catch(HL7Exception e) {
			HapiLogFactory.getHapiLog(this.getClass()).error(
			    "Unexpected error creating QBP_Q13 - this is probably a bug in the source code generator.", e);
		}
	}

	/**
	 * Returns PID (patient Identifier Segment) - creates it if necessary
	 */
	public PID getPID() {
		PID ret = null;
		try {
			ret = (PID)this.get("PID");
		}
		catch(HL7Exception e) {
			HapiLogFactory.getHapiLog(this.getClass()).error(
			    "Unexpected error accessing data - this is probably a bug in the source code generator.", e);
		}
		return ret;
	}

	public String er7Encode() throws HL7Exception {
		MSH msh = getMSH();
		char fieldSeparator = msh.getFieldSeparator().getValue().charAt(0);
		String encodingCharacters = msh.getEncodingCharacters().getValue();
		EncodingCharacters ec = new EncodingCharacters(fieldSeparator, encodingCharacters);

		StringBuffer buf = new StringBuffer();
		buf.append(PipeParser.encode(msh, ec)).append("\r");
		buf.append(PipeParser.encode(getQPD(), ec)).append("\r");
		buf.append(PipeParser.encode(getPID(), ec)).append("\r");
		buf.append(PipeParser.encode(getRDF(), ec)).append("\r");
		buf.append(PipeParser.encode(getRCP(), ec)).append("\r");
		return buf.toString();
	}
} 
